$TITLE: 26 COUNTRIE INSIDE MONEY STRUCTURE: BY CHUNDING LI
OPTION NLP=CONOPT

SET
R    COUNTRIES    /AUSTRALIA,BAHRAIN,BRAZIL,BRUNEI,CANADA,CHILE,CHINA,EU,INDIA,INDONESIA,JAPAN,KOREA,
                   KUWAIT,MALAYSIA,MEXICO,NEWZEALAND,PERU,PHILIPPINE,QATAR,RUSSIAN,ARABIA,SINGAPORE,
                   THAILAND,US,VIETNAM,ROW/
G    SECTORS      /TRADABLE, NONTRADABLE/
F    FACTORS      /K,L/
;
ALIAS (R,RR),(R,RRR),(G,GG),(F,FF);

PARAMETERS
PRN1(R,G)         TOTAL PRODUCTION
FACDEM1(R,G,F)    FACTOR DEMAND IN PRODUCTION
ELASP0(R,G)       FACTOR ELASTICITY OF SUBSTITUTION

TGDEM1(R)         ARMINGTON TRADABLE COMPOSITE GOODS DEMAND
/AUSTRALIA           364.1
 BAHRAIN             25.8
 BRAZIL              367.4
 BRUNEI              6.3
 CANADA              763.6
 CHILE               98.9
 CHINA               6159
 EU                  4376.6
 INDIA               1307.9
 INDONESIA           555.7
 JAPAN               1516.3
 KOREA               731.2
 KUWAIT              48.4
 MALAYSIA            234.3
 MEXICO              632.3
 NEWZEALAND          66.8
 PERU                80.5
 PHILIPPINE          180.0
 QATAR               64.7
 RUSSIAN             372.2
 ARABIA              247.3
 SINGAPORE           380.6
 THAILAND            284.3
 US                  4870
 VIETNAM             303.1
 ROW                 8205.0/,
GDEM1(R,RR)       TRADABLE GOODS DEMAND
NGDEM1(R)         NONTRADABLE GOODS DEMAND
/AUSTRALIA           971.9
 BAHRAIN             10.1
 BRAZIL              1391.6
 BRUNEI              2.3
 CANADA              868.3
 CHILE               171.6
 CHINA               6738.8
 EU                  13946.6
 INDIA               1521.0
 INDONESIA           428.3
 JAPAN               3281.5
 KOREA               783.0
 KUWAIT              43.1
 MALAYSIA            66.9
 MEXICO              490.7
 NEWZEALAND          121.8
 PERU                112.3
 PHILIPPINE          144.9
 QATAR               62.5
 RUSSIAN             1015.7
 ARABIA              342.3
 SINGAPORE           174.9
 THAILAND            197.7
 US                  16160.7
 VIETNAM             71.7
 ROW                 1508.3/,

MONEY1(R)         INSIDE MONEY
/AUSTRALIA           1017.3
 BAHRAIN             993.7
 BRAZIL              1058.7
 BRUNEI              1002.4
 CANADA              990.5
 CHILE               1001.3
 CHINA               1359.3
 EU                  973.1
 INDIA               814.9
 INDONESIA           991.5
 JAPAN               990.0
 KOREA               1069.6
 KUWAIT              1036
 MALAYSIA            1029.9
 MEXICO              986.4
 NEWZEALAND          996.1
 PERU                1004.8
 PHILIPPINE          952.4
 QATAR               1052.6
 RUSSIAN             1211.3
 ARABIA              1159.3
 SINGAPORE           1041.2
 THAILAND            1003.3
 US                  53.9
 VIETNAM             1006.8
 ROW                 1203.7/,

ELASC10(R)         ELASTICITY OF ARMINGTON CONSUMPTION
/AUSTRALIA           1.0
 BAHRAIN             1.0
 BRAZIL              1.0
 BRUNEI              1.0
 CANADA              1.0
 CHILE               1.0
 CHINA               1.0
 EU                  1.0
 INDIA               1.0
 INDONESIA           1.0
 JAPAN               1.0
 KOREA               1.0
 KUWAIT              1.0
 MALAYSIA            1.0
 MEXICO              1.0
 NEWZEALAND          1.0
 PERU                1.0
 PHILIPPINE          1.0
 QATAR               1.0
 RUSSIAN             1.0
 ARABIA              1.0
 SINGAPORE           1.0
 THAILAND            1.0
 US                  1.0
 VIETNAM             1.0
 ROW                 1.0/,

ELASC20(R)         ELASTICITY OF GOODS CONSUMPTION
/AUSTRALIA           1.0
 BAHRAIN             1.0
 BRAZIL              1.0
 BRUNEI              1.0
 CANADA              1.0
 CHILE               1.0
 CHINA               1.0
 EU                  1.0
 INDIA               1.0
 INDONESIA           1.0
 JAPAN               1.0
 KOREA               1.0
 KUWAIT              1.0
 MALAYSIA            1.0
 MEXICO              1.0
 NEWZEALAND          1.0
 PERU                1.0
 PHILIPPINE          1.0
 QATAR               1.0
 RUSSIAN             1.0
 ARABIA              1.0
 SINGAPORE           1.0
 THAILAND            1.0
 US                  1.0
 VIETNAM             1.0
 ROW                 1.0/,

ENDW(R,F)         ENDOWMENT OF FACTORS BY INDIVIDUAL
TARIFF(R,RR)      IMPORT TARIFF
NTARIFF(R,RR)     NON-TARIFF BARRIER
RTA(R,RR)         PARAMETER OF TARIFF USED FOR CALCULATING FTA CHANGE
FTA(R,RR)         JOINT FTA EFFECT
WAR(R,RR)         CHINA-US TRADE WAR
;

TABLE PRN1(R,G)
                    TRADABLE          NONTRADABLE
AUSTRALIA           381.4             1052.5
BAHRAIN             19.5              18.2
BRAZIL              426.1             1442.5
BRUNEI              8.7               4.9
CANADA              754.1             959.2
CHILE               100.2             198.0
CHINA               6518.3            7089.9
EU                  4349.7            14398.9
INDIA               1122.8            1595.9
INDONESIA           547.2             495
JAPAN               1506.3            3465
KOREA               800.8             818.6
KUWAIT              84.4              56.2
MALAYSIA            264.2             94.4
MEXICO              618.7             602.0
NEWZEALAND          62.9              142.0
PERU                85.3              136.8
PHILIPPINE          132.4             198.5
QATAR               117.3             74.1
RUSSIAN             583.5             1074.1
ARABIA              406.6             379.9
SINGAPORE           421.8             242.4
THAILAND            287.6             217.3
US                  3923.9            16620.4
VIETNAM             309.9             115.3
ROW                 8408.7            2655.4  ;

TABLE FACDEM1(R,G,F)
                                     K                L
AUSTRALIA.TRADABLE                   91.5             289.9
AUSTRALIA.NONTRADABLE                252.6            799.9
BAHRAIN.TRADABLE                     6.3              13.2
BAHRAIN.NONTRADABLE                  5.8              12.4
BRAZIL.TRADABLE                      63.9             362.2
BRAZIL.NONTRADABLE                   216.4            1226.1
BRUNEI.TRADABLE                      3.5              5.2
BRUNEI.NONTRADABLE                   2.1              2.8
CANADA.TRADABLE                      173.5            580.6
CANADA.NONTRADABLE                   220.6            738.6
CHILE.TRADABLE                       23.1             77.1
CHILE.NONTRADABLE                    45.5             152.5
CHINA.TRADABLE                       2868             3650.3
CHINA.NONTRADABLE                    3119.6           3970.3
EU.TRADABLE                          913.4            3436.3
EU.NONTRADABLE                       3023.8           11375.1
INDIA.TRADABLE                       348.1            774.7
INDIA.NONTRADABLE                    494.7            1101.2
INDONESIA.TRADABLE                   191.5            355.7
INDONESIA.NONTRADABLE                173.3            321.7
JAPAN.TRADABLE                       361.5            1144.8
JAPAN.NONTRADABLE                    831.6            2633.4
KOREA.TRADABLE                       240.2            560.6
KOREA.NONTRADABLE                    245.6            573
KUWAIT.TRADABLE                      21.1             63.3
KUWAIT.NONTRADABLE                   14.1             42.1
MALAYSIA.TRADABLE                    63.4             200.8
MALAYSIA.NONTRADABLE                 22.7             71.7
MEXICO.TRADABLE                      142.3            476.4
MEXICO.NONTRADABLE                   138.5            463.5
NEWZEALAND.TRADABLE                  15.1             47.8
NEWZEALAND.NONTRADABLE               34.1             107.9
PERU.TRADABLE                        17.9             67.4
PERU.NONTRADABLE                     28.7             108.1
PHILIPPINE.TRADABLE                  35.7             96.7
PHILIPPINE.NONTRADABLE               53.6             144.9
QATAR.TRADABLE                       50.4             66.9
QATAR.NONTRADABLE                    31.9             42.2
RUSSIAN.TRADABLE                     134.1            449.4
RUSSIAN.NONTRADABLE                  247.1            827.0
ARABIA.TRADABLE                      97.6             309.0
ARABIA.NONTRADABLE                   91.2             288.7
SINGAPORE.TRADABLE                   113.9            307.9
SINGAPORE.NONTRADABLE                65.4             177.0
THAILAND.TRADABLE                    71.9             215.7
THAILAND.NONTRADABLE                 54.3             163.0
US.TRADABLE                          1824             2099.9
US.NONTRADABLE                       2490.3           14130.1
VIETNAM.TRADABLE                     83.7             226.2
VIETNAM.NONTRADABLE                  31.1             84.2
ROW.TRADABLE                         2018.1           6390.6
ROW.NONTRADABLE                      637.3            2018.1   ;


TABLE ELASP0(R,G)
                    TRADABLE           NONTRADABLE
AUSTRALIA           1.0                1.0
BAHRAIN             1.0                1.0
BRAZIL              1.0                1.0
BRUNEI              1.0                1.0
CANADA              1.0                1.0
CHILE               1.0                1.0
CHINA               1.0                1.0
EU                  1.0                1.0
INDIA               1.0                1.0
INDONESIA           1.0                1.0
JAPAN               1.0                1.0
KOREA               1.0                1.0
KUWAIT              1.0                1.0
MALAYSIA            1.0                1.0
MEXICO              1.0                1.0
NEWZEALAND          1.0                1.0
PERU                1.0                1.0
PHILIPPINE          1.0                1.0
QATAR               1.0                1.0
RUSSIAN             1.0                1.0
ARABIA              1.0                1.0
SINGAPORE           1.0                1.0
THAILAND            1.0                1.0
US                  1.0                1.0
VIETNAM             1.0                1.0
ROW                 1.0                1.0  ;

TABLE GDEM1(R,RR)

                    AUSTRALIA   BAHRAIN   BRAZIL    BRUNEI   CANADA    CHILE    CHINA      EU       INDIA   INDONESIA   JAPAN     KOREA     KUWAIT   MALAYSIA   MEXICO
AUSTRALIA           128.6       0.075     0.664     0.582    1.703     0.372    57.699     41.871   3.846   2.801       4.242     10.182    0.042    8.311      1.001
BAHRAIN             0.946       5.2       0.673     0        0.186     0.103    1.878      2.548    0.769   0.087       0.795     0.251     0.112    0.137      0.074
BRAZIL              1.125       0.117     186.2     0.001    2.252     3.382    34.731     38.759   3.663   1.331       4.356     5.381     0.213    1.531      4.369
BRUNEI              0.047       0         0.001     2.1      0.007     0.002    1.641      0.721    0.069   0.072       0.001     0.097     0        0.451      0.004
CANADA              1.619       0.028     4.247     0.006    303.7     1.396    58.319     48.177   3.958   1.358       12.997    7.295     0.031    2.302      14.034
CHILE               0.258       0.001     6.678     0.001    0.889     24.7     17.504     11.612   0.977   0.194       2.491     1.871     0        0.247      2.059
CHINA               105.083     0.151     77.142    0.248    28.354    26.999   4024.1     245.173  18.851  27.127      180.402   204.566   15.359   34.413     7.169
EU                  13.169      1.695     37.131    0.152    36.031    9.562    465.022    2041.5   53.978  19.516      82.859    60.026    3.875    30.169     30.512
INDIA               14.081      0.585     4.621     0.433    3.467     1.669    73.605     52.755   800.3   13.725      12.537    16.388    7.805    8.991      1.378
INDONESIA           5.826       0.069     1.803     0.021    1.841     0.115    45.537     11.137   5.017   367.0       17.977    9.089     0.267    8.603      0.287
JAPAN               45.681      1.241     6.886     2.269    11.731    7.409    173.612    74.271   5.498   19.479      768.1     32.112    7.248    17.109     3.275
KOREA               20.717      0.563     3.908     0.611    5.751     4.475    106.488    57.541   5.885   9.532       54.603    196.0     12.794   8.344      2.277
KUWAIT              0           0.771     0.291     0.001    0.243     0.032    5.979      6.589    1.861   0.228       2.104     1.408     12.5     0.307      0.209
MALAYSIA            5.345       0.109     1.965     0.433    0.809     0.125    43.316     16.562   6.559   9.437       15.729    9.629     0.478    16.900     0.368
MEXICO              0.328       0.0445    6.508     0.001    10.752    1.667    83.509     45.984   5.232   1.587       18.189    16.725    0.017    2.073      168.0
NEWZEALAND          5.019       0.009     0.126     0.001    0.487     0.089    8.643      6.601    0.509   0.643       3.036     2.004     0.009    1.447      0.317
PERU                0.116       0.001     2.415     0        0.703     1.367    10.059     4.349    0.902   0.286       1.054     0.972     0.001    0.234      1.647
PHILIPPINE          1.538       0.024     0.642     0.036    0.791     0.041    22.579     8.932    1.784   6.789       11.397    11.503    1.394    4.285      0.154
QATAR               0.703       0.009     0.321     0        0.169     0.014    3.916      12.441   1.991   0.149       1.383     0.588     0.327    0.322      0.192
RUSSIAN             0.671       0.007     2.471     0        0.746     1.058    52.218     99.729   3.225   1.715       8.822     7.009     0        1.627      0.938
ARABIA              0.649       1.555     2.309     0.001    1.714     0.148    22.244     34.641   5.685   1.578       5.474     4.301     0.417    1.167      0.745
SINGAPORE           5.457       0.124     1.555     0.525    1.542     0.091    49.634     43.516   7.262   12.992      22.149    14.193    4.073    34.471     2.346
THAILAND            5.935       0.166     2.064     0.859    0.981     0.452    49.953     17.522   4.863   8.045       35.259    8.847     0.929    14.062     0.653
US                  10.209      1.025     32.286    0.102    325.684   12.201   563.203    472.782  56.444  18.472      145.902   76.201    2.126    22.525     344.661
VIETNAM             3.201       0.013     1.838     0.052    0.799     0.283    58.533     12.971   3.955   3.656       16.917    46.943    0.288    8.475      0.788
ROW                 5.077       5.918     41.355    0.265    12.768    2.448    484.378    941.016  119.717 19.401      77.525    57.219    14.095   35.697     31.243

+
                    NEWZEALAND  PERU    PHILIPPINE  QATAR    RUSSIAN   ARABIA   SINGAPORE  THAILAND     US        VIETNAM    ROW
AUSTRALIA           6.057       0.256    0.551      0.355    0.181     0.476    8.822      11.524       24.666    3.966      45.255
BAHRAIN             0.053       0.002    0.029      0        0.099     6.814    0.111      0.286        1.206     0.173      3.268
BRAZIL              0.061       1.811    0.271      0.273    3.374     2.319    0.646      1.651        29.351    2.059      38.173
BRUNEI              0.005       0        0.014      0.003    0.001     0.002    0.374      0.109        0.361     0.017      0.201
CANADA              0.579       1.099    1.121      0.069    1.141     2.939    0.974      2.749        235.118   3.014      55.33
CHILE               0.138       1.156    0.052      0        0.071     0.033    0.101      0.987        13.999    0.768      12.113
CHINA               11.079      15.213   8.698      9.091    58.887    45.899   33.638     44.919       156.004   41.366     739.069
EU                  4.075       7.183    9.359      8.525    179.625   36.076   23.509     26.886       313.541   45.089     837.535
INDIA               0.633       2.454    0.615      10.587   6.801     28.431   14.437     7.647        32.715    6.544      184.696
INDONESIA           0.808       0.056    0.958      1.411    1.551     4.911    21.439     10.953       10.212    3.534      25.278
JAPAN               2.651       2.454    9.473      14.856   15.587    33.775   9.733      25.058       83.571    18.834     124.387
KOREA               1.379       2.474    2.542      16.294   17.504    26.336   7.974      5.582        59.081    18.241     84.304
KUWAIT              0.068       0.004    0.071      0.051    0.229     2.042    0.151      0.409        3.104     0.527      9.221
MALAYSIA            0.826       0.112    1.929      0.676    1.157     4.433    25.474     12.035       16.094    4.065      39.735
MEXICO              0.291       0.474    0.606      0.059    1.969     0.089    1.669      6.359        216.271   2.239      41.658
NEWZEALAND          23.1        0.039    0.099      0.055    0.166     0.387    1.476      1.921        4.425     0.639      5.553
PERU                0.133       37.4     0.058      0.019    0.438     0.183    0.068      0.401        9.174     0.353      8.167
PHILIPPINE          0.518       0.108    64.9       0.389    1.301     1.892    6.311      7.948        8.297     3.465      12.982
QATAR               0.032       0.072    0.072      33.0     0.282     0.015    0.214      0.367        6.177     0.258      1.686
RUSSIAN             0.136       0.182    0.417      0.036    132.0     0.292    0.869      1.856        12.691    2.446      41.039
ARABIA              0.476       0.011    0.257      0        1.221     112.1    1.289      1.993        18.041    1.585      27.699
SINGAPORE           0.808       0.013    4.234      6.784    5.761     12.631   10.1       8.291        42.103    3.467      86.478
THAILAND            0.719       0.135    2.717      3.532    2.395     7.316    7.696      35.1         15.201    5.268      53.631
US                  4.364       8.272    10.551     1.619    21.596    24.616   26.879     33.027       2258.6    47.581     349.072
VIETNAM             0.502       0.117    1.158      0.138    1.392     1.309    5.319      10.702       9.343     66.2       48.208
ROW                 3.409       4.203    11.648     9.478    128.771   51.284   212.527    28.84        344.554   28.202     612.6   ;

TABLE ENDW(R,F)
                     K                L
AUSTRALIA            344.1            1089.8
BAHRAIN              12.1             25.6
BRAZIL               280.3            1588.3
BRUNEI               5.6              8.0
CANADA               394.1            1319.2
CHILE                68.6             229.6
CHINA                5987.6           7620.6
EU                   3937.2           14811.4
INDIA                842.8            1875.9
INDONESIA            364.8            677.4
JAPAN                1193.1           3778.2
KOREA                485.8            1133.6
KUWAIT               35.2             105.4
MALAYSIA             86.1             272.5
MEXICO               280.8            939.9
NEWZEALAND           49.2             155.7
PERU                 46.6             175.5
PHILIPPINE           89.3             241.6
QATAR                82.3             109.1
RUSSIAN              381.2            1276.4
ARABIA               188.8            597.7
SINGAPORE            179.3            484.9
THAILAND             126.2            378.7
US                   4314.3           16230.0
VIETNAM              114.8            310.4
ROW                  2655.4           8408.7   ;

TABLE TARIFF(R,RR)

                    AUSTRALIA  BAHRAIN  BRAZIL  BRUNEI  CANADA  CHILE  CHINA  EU     INDIA  INDONESIA  JAPAN  KOREA  KUWAIT  MALAYSIA  MEXICO
AUSTRALIA           0          0.025    0.025   0.025   0.025   0.025  0.025  0.025  0.025  0.025      0.025  0.025  0.025   0.025     0.025
BAHRAIN             0.053      0        0.053   0.053   0.053   0.053  0.053  0.053  0.053  0.053      0.053  0.053  0.053   0.053     0.053
BRAZIL              0.134      0.134    0       0.134   0.134   0.134  0.134  0.134  0.134  0.134      0.134  0.134  0.134   0.134     0.134
BRUNEI              0.321      0.321    0.321   0       0.321   0.321  0.321  0.321  0.321  0.321      0.321  0.321  0.321   0.321     0.321
CANADA              0.040      0.040    0.040   0.040   0       0.040  0.040  0.040  0.040  0.040      0.040  0.040  0.040   0.040     0.040
CHILE               0.060      0.060    0.060   0.060   0.060   0      0.060  0.060  0.060  0.060      0.060  0.060  0.060   0.060     0.060
CHINA               0.098      0.098    0.098   0.098   0.098   0.098  0      0.098  0.098  0.098      0.098  0.098  0.098   0.098     0.098
EU                  0.052      0.052    0.052   0.052   0.052   0.052  0.052  0      0.052  0.052      0.052  0.052  0.052   0.052     0.052
INDIA               0.171      0.171    0.171   0.171   0.171   0.171  0.171  0.171  0      0.171      0.171  0.171  0.171   0.171     0.171
INDONESIA           0.081      0.081    0.081   0.081   0.081   0.081  0.081  0.081  0.081  0          0.081  0.081  0.081   0.081     0.081
JAPAN               0.044      0.044    0.044   0.044   0.044   0.044  0.044  0.044  0.044  0.044      0      0.044  0.044   0.044     0.044
KOREA               0.137      0.137    0.137   0.137   0.137   0.137  0.137  0.137  0.137  0.137      0.137  0      0.137   0.137     0.137
KUWAIT              0.047      0.047    0.047   0.047   0.047   0.047  0.047  0.047  0.047  0.047      0.047  0.047  0       0.047     0.047
MALAYSIA            0.056      0.056    0.056   0.056   0.056   0.056  0.056  0.056  0.056  0.056      0.056  0.056  0.056   0         0.056
MEXICO              0.070      0.070    0.070   0.070   0.070   0.070  0.070  0.070  0.070  0.070      0.070  0.070  0.070   0.070     0
NEWZEALAND          0.020      0.020    0.020   0.020   0.020   0.020  0.020  0.020  0.020  0.020      0.020  0.020  0.020   0.020     0.020
PERU                0.024      0.024    0.024   0.024   0.024   0.024  0.024  0.024  0.024  0.024      0.024  0.024  0.024   0.024     0.024
PHILIPPINE          0.062      0.062    0.062   0.062   0.062   0.062  0.062  0.062  0.062  0.062      0.062  0.062  0.062   0.062     0.062
QATAR               0.048      0.048    0.048   0.048   0.048   0.048  0.048  0.048  0.048  0.048      0.048  0.048  0.048   0.048     0.048
RUSSIAN             0.068      0.068    0.068   0.068   0.068   0.068  0.068  0.068  0.068  0.068      0.068  0.068  0.068   0.068     0.068
ARABIA              0.053      0.053    0.053   0.053   0.053   0.053  0.053  0.053  0.053  0.053      0.053  0.053  0.053   0.053     0.053
SINGAPORE           0.001      0.001    0.001   0.001   0.001   0.001  0.001  0.001  0.001  0.001      0.001  0.001  0.001   0.001     0.001
THAILAND            0.096      0.096    0.096   0.096   0.096   0.096  0.096  0.096  0.096  0.096      0.096  0.096  0.096   0.096     0.096
US                  0.035      0.035    0.035   0.035   0.035   0.035  0.035  0.035  0.035  0.035      0.035  0.035  0.035   0.035     0.035
VIETNAM             0.095      0.095    0.095   0.095   0.095   0.095  0.095  0.095  0.095  0.095      0.095  0.095  0.095   0.095     0.095
ROW                 0.061      0.061    0.061   0.061   0.061   0.061  0.061  0.061  0.061  0.061      0.061  0.061  0.061   0.061     0.061

+
                    NEWZEALAND  PERU     PHILIPPINE  QATAR    RUSSIAN  ARABIA  SINGAPORE  THAILAND   US      VIETNAM  ROW
AUSTRALIA           0.025       0.025    0.025       0.025    0.025    0.025   0.025      0.025      0.025   0.025    0.025
BAHRAIN             0.053       0.053    0.053       0.053    0.053    0.053   0.053      0.053      0.053   0.053    0.053
BRAZIL              0.134       0.134    0.134       0.134    0.134    0.134   0.134      0.134      0.134   0.134    0.134
BRUNEI              0.321       0.321    0.321       0.321    0.321    0.321   0.321      0.321      0.321   0.321    0.321
CANADA              0.040       0.040    0.040       0.040    0.040    0.040   0.040      0.040      0.040   0.040    0.040
CHILE               0.060       0.060    0.060       0.060    0.060    0.060   0.060      0.060      0.060   0.060    0.060
CHINA               0.098       0.098    0.098       0.098    0.098    0.098   0.098      0.098      0.098   0.098    0.098
EU                  0.052       0.052    0.052       0.052    0.052    0.052   0.052      0.052      0.052   0.052    0.052
INDIA               0.171       0.171    0.171       0.171    0.171    0.171   0.171      0.171      0.171   0.171    0.171
INDONESIA           0.081       0.081    0.081       0.081    0.081    0.081   0.081      0.081      0.081   0.081    0.081
JAPAN               0.044       0.044    0.044       0.044    0.044    0.044   0.044      0.044      0.044   0.044    0.044
KOREA               0.137       0.137    0.137       0.137    0.137    0.137   0.137      0.137      0.137   0.137    0.137
KUWAIT              0.047       0.047    0.047       0.047    0.047    0.047   0.047      0.047      0.047   0.047    0.047
MALAYSIA            0.056       0.056    0.056       0.056    0.056    0.056   0.056      0.056      0.056   0.056    0.056
MEXICO              0.070       0.070    0.070       0.070    0.070    0.070   0.070      0.070      0.070   0.070    0.070
NEWZEALAND          0           0.020    0.020       0.020    0.020    0.020   0.020      0.020      0.020   0.020    0.020
PERU                0.024       0        0.024       0.024    0.024    0.024   0.024      0.024      0.024   0.024    0.024
PHILIPPINE          0.062       0.062    0           0.062    0.062    0.062   0.062      0.062      0.062   0.062    0.062
QATAR               0.048       0.048    0.048       0        0.048    0.048   0.048      0.048      0.048   0.048    0.048
RUSSIAN             0.068       0.068    0.068       0.068    0        0.068   0.068      0.068      0.068   0.068    0.068
ARABIA              0.053       0.053    0.053       0.053    0.053    0       0.053      0.053      0.053   0.053    0.053
SINGAPORE           0.001       0.001    0.001       0.001    0.001    0.001   0          0.001      0.001   0.001    0.001
THAILAND            0.096       0.096    0.096       0.096    0.096    0.096   0.096      0          0.096   0.096    0.096
US                  0.035       0.035    0.035       0.035    0.035    0.035   0.035      0.035      0       0.035    0.035
VIETNAM             0.095       0.095    0.095       0.095    0.095    0.095   0.095      0.095      0.095   0        0.095
ROW                 0.061       0.061    0.061       0.061    0.061    0.061   0.061      0.061      0.061   0.061    0       ;

TABLE NTARIFF(R,RR)

                    AUSTRALIA  BAHRAIN  BRAZIL  BRUNEI  CANADA  CHILE  CHINA  EU     INDIA  INDONESIA  JAPAN  KOREA  KUWAIT  MALAYSIA  MEXICO
AUSTRALIA           0          0.855    1.045   0.622   0.692   0.785  0.292  0.508  0.523  0.592      0.354  0.227  0.915   0.225     0.836
BAHRAIN             0.827      0        0.845   0.006   0.897   0.006  0.668  0.513  0.410  1.020      0.572  0.385  0.474   0.435     1.227
BRAZIL              0.936      0.764    0       0.001   0.487   0.321  0.277  0.310  0.453  0.740      0.492  0.258  0.653   0.364     0.409
BRUNEI              0.644      0.251    0.251   0       0.251   0.251  0.560  1.059  0.251  0.631      0.522  0.344  0.251   0.261     0.251
CANADA              0.677      0.910    0.581   0.002   0       0.529  0.333  0.321  0.499  0.709      0.374  0.287  0.926   0.389     0.237
CHILE               0.750      0.000    0.395   0.000   0.509   0      0.320  0.421  0.509  1.057      0.478  0.252  0.000   0.588     0.451
CHINA               0.219      0.623    0.313   0.465   0.275   0.282  0      0.206  0.312  0.363      0.156  0.035  0.427   0.034     0.379
EU                  0.481      0.514    0.392   1.010   0.309   0.429  0.252  0      0.318  0.607      0.369  0.203  0.449   0.220     0.382
INDIA               0.377      0.292    0.416   0.036   0.368   0.398  0.239  0.199  0      0.290      0.343  0.131  0.148   0.027     0.381
INDONESIA           0.536      0.992    0.793   0.553   0.668   1.036  0.380  0.578  0.380  0          0.346  0.228  0.762   0.112     0.917
JAPAN               0.335      0.581    0.582   0.481   0.370   0.494  0.210  0.377  0.470  0.383      0      0.101  0.376   0.131     0.504
KOREA               0.115      0.301    0.255   0.210   0.190   0.175  0.002  0.118  0.165  0.172      0.008  0      0.075   0.026     0.219
KUWAIT              0.893      0.480    0.740   0.000   0.919   0.000  0.478  0.454  0.272  0.796      0.373  0.165  0       0.614     0.000
MALAYSIA            0.194      0.432    0.442   0.208   0.373   0.592  0.076  0.216  0.142  0.137      0.119  0.007  0.605   0         0.519
MEXICO              0.791      1.210    0.473   0.009   0.207   0.441  0.407  0.364  0.482  0.928      0.478  0.286  0.009   0.505     0
NEWZEALAND          0.280      0.000    1.188   0.602   0.688   1.008  0.494  0.588  0.746  0.772      0.546  0.388  0.000   0.312     0.888
PERU                1.376      0.010    0.655   0.010   0.590   0.445  0.571  0.672  0.778  1.402      0.753  0.468  0.010   0.901     0.671
PHILIPPINE          0.714      0.001    0.891   0.880   0.645   1.081  0.426  0.612  0.711  0.642      0.399  0.242  1.201   0.263     0.819
QATAR               0.651      0.306    0.668   0.001   0.749   1.084  0.423  0.308  0.227  0.701      0.225  0.079  0.585   0.311     0.880
RUSSIAN             0.973      0.029    0.699   0.029   0.754   1.047  0.341  0.141  0.593  0.837      0.414  0.237  0.029   0.560     0.867
ARABIA              0.877      0.226    0.574   0.005   0.567   1.113  0.309  0.308  0.166  0.558      0.300  0.091  0.494   0.367     0.839
SINGAPORE           0.191      0.379    0.502   0.208   0.427   0.818  0.129  0.199  0.129  0.094      0.198  0.012  0.812   0.161     0.482
THAILAND            0.057      0.168    0.285   0.115   0.228   0.346  0.048  0.097  0.081  0.074      0.042  0.049  0.453   0.019     0.255
US                  0.528      0.632    0.418   1.061   0.001   0.376  0.250  0.249  0.367  0.604      0.298  0.177  0.470   0.217     0.036
VIETNAM             0.254      0.000    0.440   0.388   0.351   0.477  0.065  0.205  0.155  0.306      0.101  0.014  0.656   0.033     0.533
ROW                 0.160      0.027    0.121   0.476   0.178   0.221  0.659  0.663  0.724  0.461      0.074  0.056  0.122   0.070     0.185

+
                    NEWZEALAND  PERU     PHILIPPINE  QATAR   RUSSIAN  ARABIA  SINGAPORE  THAILAND    US      VIETNAM  ROW
AUSTRALIA           0.275       1.375    0.751       0.674   1.016    0.905   0.166      0.128       0.538   0.324    0.196
BAHRAIN             0.006       0.006    0.006       0.301   0.006    0.226   0.326      0.211       0.614   0.094    0.135
BRAZIL              1.074       0.545    0.819       0.582   0.633    0.493   0.368      0.247       0.319   0.401    0.048
BRUNEI              0.619       0.251    0.939       0.251   0.251    0.251   0.305      0.308       1.093   0.480    0.534
CANADA              0.668       0.574    0.667       0.757   0.782    0.580   0.387      0.284       0.084   0.406    0.199
CHILE               0.968       0.409    1.083       1.072   1.055    1.106   0.758      0.382       0.351   0.512    0.222
CHINA               0.416       0.497    0.390       0.373   0.311    0.264   0.031      0.086       0.187   0.062    0.122
EU                  0.556       0.644    0.622       0.304   0.157    0.309   0.147      0.141       0.232   0.248    0.072
INDIA               0.595       0.631    0.602       0.104   0.490    0.048   0.012      0.006       0.231   0.079    0.048
INDONESIA           0.711       1.345    0.623       0.668   0.824    0.530   0.013      0.089       0.558   0.320    0.441
JAPAN               0.522       0.733    0.417       0.229   0.438    0.309   0.154      0.094       0.289   0.152    0.091
KOREA               0.271       0.355    0.167       0.020   0.168    0.007   0.075      0.008       0.075   0.072    0.080
KUWAIT              0.000       0.000    1.216       0.586   0.000    0.500   0.765      0.502       0.458   0.704    0.136
MALAYSIA            0.276       0.869    0.269       0.303   0.572    0.364   0.105      0.059       0.196   0.172    0.075
MEXICO              0.838       0.625    0.811       0.858   0.865    0.822   0.412      0.281       0.101   0.558    0.176
NEWZEALAND          0           1.165    0.763       0.706   0.927    0.645   0.274      0.259       0.599   0.452    0.296
PERU                1.161       0.000    1.277       0.010   1.151    1.495   1.115      0.549       0.529   1.086    0.354
PHILIPPINE          0.721       1.239    0.000       0.713   1.030    0.824   0.152      0.146       0.551   0.422    0.655
QATAR               0.678       0.001    0.727       0.000   1.185    0.365   0.070      0.078       0.493   0.411    0.160
RUSSIAN             0.879       1.107    1.024       1.165   0.000    0.961   0.497      0.345       0.512   0.379    0.060
ARABIA              0.612       1.466    0.833       0.360   0.976    0.000   0.260      0.272       0.313   0.368    0.099
SINGAPORE           0.294       1.139    0.214       0.118   0.565    0.313   0.000      0.128       0.196   0.008    0.168
THAILAND            0.183       0.477    0.112       0.030   0.317    0.229   0.032      0.000       0.085   0.137    0.093
US                  0.584       0.518    0.578       0.506   0.545    0.331   0.161      0.146       0.000   0.265    0.040
VIETNAM             0.377       1.015    0.389       0.364   0.352    0.326   0.013      0.038       0.205   0.000    0.539
ROW                 0.255       0.317    0.656       0.147   0.067    0.091   0.107      0.048       0.047   0.573    0.000  ;

TABLE RTA(R,RR)

                    AUSTRALIA  BAHRAIN  BRAZIL  BRUNEI  CANADA  CHILE  CHINA  EU    INDIA  INDONESIA  JAPAN  KOREA  KUWAIT  MALAYSIA  MEXICO
AUSTRALIA           0          1        1       1       1       1      1      1     1      1          1      1      1       1         1
BAHRAIN             1          0        1       1       1       1      1      1     1      1          1      1      1       1         1
BRAZIL              1          1        0       1       1       1      1      1     1      1          1      1      1       1         1
BRUNEI              1          1        1       0       1       1      1      1     1      1          1      1      1       1         1
CANADA              1          1        1       1       0       1      1      1     1      1          1      1      1       1         1
CHILE               1          1        1       1       1       0      1      1     1      1          1      1      1       1         1
CHINA               1          1        1       1       1       1      0      1     1      1          1      1      1       1         1
EU                  1          1        1       1       1       1      1      0     1      1          1      1      1       1         1
INDIA               1          1        1       1       1       1      1      1     0      1          1      1      1       1         1
INDONESIA           1          1        1       1       1       1      1      1     1      0          1      1      1       1         1
JAPAN               1          1        1       1       1       1      1      1     1      1          0      1      1       1         1
KOREA               1          1        1       1       1       1      1      1     1      1          1      0      1       1         1
KUWAIT              1          1        1       1       1       1      1      1     1      1          1      1      0       1         1
MALAYSIA            1          1        1       1       1       1      1      1     1      1          1      1      1       0         1
MEXICO              1          1        1       1       1       1      1      1     1      1          1      1      1       1         0
NEWZEALAND          1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
PERU                1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
PHILIPPINE          1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
QATAR               1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
RUSSIAN             1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
ARABIA              1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
SINGAPORE           1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
THAILAND            1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
US                  1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
VIETNAM             1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
ROW                 1          1        1       1       1       1      1      1     1      1          1      1      1       1         1

+
                    NEWZEALAND  PERU  PHILIPPINE  QATAR  RUSSIAN   ARABIA  SINGAPORE  THAILAND  US  VIETNAM  ROW
AUSTRALIA           1           1     1           1      1         1       1          1         1   1        1
BAHRAIN             1           1     1           1      1         1       1          1         1   1        1
BRAZIL              1           1     1           1      1         1       1          1         1   1        1
BRUNEI              1           1     1           1      1         1       1          1         1   1        1
CANADA              1           1     1           1      1         1       1          1         1   1        1
CHILE               1           1     1           1      1         1       1          1         1   1        1
CHINA               1           1     1           1      1         1       1          1         1   1        1
EU                  1           1     1           1      1         1       1          1         1   1        1
INDIA               1           1     1           1      1         1       1          1         1   1        1
INDONESIA           1           1     1           1      1         1       1          1         1   1        1
JAPAN               1           1     1           1      1         1       1          1         1   1        1
KUWAIT              1           1     1           1      1         1       1          1         1   1        1
MALAYSIA            1           1     1           1      1         1       1          1         1   1        1
MEXICO              1           1     1           1      1         1       1          1         1   1        1
NEWZEALAND          0           1     1           1      1         1       1          1         1   1        1
PERU                1           0     1           1      1         1       1          1         1   1        1
PHILIPPINE          1           1     0           1      1         1       1          1         1   1        1
QATAR               1           1     1           0      1         1       1          1         1   1        1
RUSSIAN             1           1     1           1      0         1       1          1         1   1        1
ARABIA              1           1     1           1      1         0       1          1         1   1        1
SINGAPORE           1           1     1           1      1         1       0          1         1   1        1
THAILAND            1           1     1           1      1         1       1          0         1   1        1
US                  1           1     1           1      1         1       1          1         0   1        1
VIETNAM             1           1     1           1      1         1       1          1         1   0        1
ROW                 1           1     1           1      1         1       1          1         1   1        0  ;


TABLE FTA(R,RR)

                    AUSTRALIA  BAHRAIN  BRAZIL  BRUNEI  CANADA  CHILE  CHINA  EU    INDIA  INDONESIA  JAPAN  KOREA  KUWAIT  MALAYSIA  MEXICO
AUSTRALIA           0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
BAHRAIN             1          0        1       1       1       1      1      1     1      1          1      1      1       1         1
BRAZIL              1          1        0       1       1       1      1      1     1      1          1      1      1       1         1
BRUNEI              0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
CANADA              1          1        1       1       0       1      1      1     1      1          1      1      1       1         1
CHILE               1          1        1       1       1       0      1      1     1      1          1      1      1       1         1
CHINA               0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
EU                  1          1        1       1       1       1      1      0     1      1          1      1      1       1         1
INDIA               0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
INDONESIA           0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
JAPAN               0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
KOREA               0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
KUWAIT              1          1        1       1       1       1      1      1     1      1          1      1      0       1         1
MALAYSIA            0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
MEXICO              1          1        1       1       1       1      1      1     1      1          1      1      1       1         0
NEWZEALAND          0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
PERU                1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
PHILIPPINE          0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
QATAR               1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
RUSSIAN             1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
ARABIA              1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
SINGAPORE           0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
THAILAND            0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
US                  1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
VIETNAM             0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
ROW                 1          1        1       1       1       1      1      1     1      1          1      1      1       1         1

+
                    NEWZEALAND  PERU  PHILIPPINE  QATAR  RUSSIAN   ARABIA  SINGAPORE  THAILAND  US  VIETNAM  ROW
AUSTRALIA           0           1     0           1      1         1       0          0         1   0        1
BAHRAIN             1           1     1           1      1         1       1          1         1   1        1
BRAZIL              1           1     1           1      1         1       1          1         1   1        1
BRUNEI              0           1     0           1      1         1       0          0         1   0        1
CANADA              1           1     1           1      1         1       1          1         1   1        1
CHILE               1           1     1           1      1         1       1          1         1   1        1
CHINA               0           1     0           1      1         1       0          0         1   0        1
EU                  1           1     1           1      1         1       1          1         1   1        1
INDIA               0           1     0           1      1         1       0          0         1   0        1
INDONESIA           0           1     0           1      1         1       0          0         1   0        1
JAPAN               0           1     0           1      1         1       0          0         1   0        1
KOREA               0           1     0           1      1         1       0          0         1   0        1
KUWAIT              1           1     1           1      1         1       1          1         1   1        1
MALAYSIA            0           1     0           1      1         1       0          0         1   0        1
MEXICO              1           1     1           1      1         1       1          1         1   1        1
NEWZEALAND          0           1     0           1      1         1       0          0         1   0        1
PERU                1           0     1           1      1         1       1          1         1   1        1
PHILIPPINE          0           1     0           1      1         1       0          0         1   0        1
QATAR               1           1     1           0      1         1       1          1         1   1        1
RUSSIAN             1           1     1           1      0         1       1          1         1   1        1
ARABIA              1           1     1           1      1         0       1          1         1   1        1
SINGAPORE           0           1     0           1      1         1       0          0         1   0        1
THAILAND            0           1     0           1      1         1       0          0         1   0        1
US                  1           1     1           1      1         1       1          1         0   1        1
VIETNAM             0           1     0           1      1         1       0          0         1   0        1
ROW                 1           1     1           1      1         1       1          1         1   1        0   ;


TABLE WAR(R,RR)

                    AUSTRALIA  BAHRAIN  BRAZIL  BRUNEI  CANADA  CHILE  CHINA  EU    INDIA  INDONESIA  JAPAN  KOREA  KUWAIT  MALAYSIA  MEXICO
AUSTRALIA           0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
BAHRAIN             0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
BRAZIL              0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
BRUNEI              0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
CANADA              0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
CHILE               0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
CHINA               0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
EU                  0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
INDIA               0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
INDONESIA           0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
JAPAN               0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
KOREA               0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
KUWAIT              0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
MALAYSIA            0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
MEXICO              0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
NEWZEALAND          0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
PERU                0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
PHILIPPINE          0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
QATAR               0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
RUSSIAN             0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
ARABIA              0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
SINGAPORE           0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
THAILAND            0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
US                  0          0        0       0       0       0      1      0     0      0          0      0      0       0         0
VIETNAM             0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
ROW                 0          0        0       0       0       0      0      0     0      0          0      0      0       0         0

+
                    NEWZEALAND  PERU  PHILIPPINE  QATAR  RUSSIAN   ARABIA  SINGAPORE  THAILAND  US  VIETNAM  ROW
AUSTRALIA           0           0     0           0      0         0       0          0         0   0        0
BAHRAIN             0           0     0           0      0         0       0          0         0   0        0
BRAZIL              0           0     0           0      0         0       0          0         0   0        0
BRUNEI              0           0     0           0      0         0       0          0         0   0        0
CANADA              0           0     0           0      0         0       0          0         0   0        0
CHILE               0           0     0           0      0         0       0          0         0   0        0
CHINA               0           0     0           0      0         0       0          0         1   0        0
EU                  0           0     0           0      0         0       0          0         0   0        0
INDIA               0           0     0           0      0         0       0          0         0   0        0
INDONESIA           0           0     0           0      0         0       0          0         0   0        0
JAPAN               0           0     0           0      0         0       0          0         0   0        0
KOREA               0           0     0           0      0         0       0          0         0   0        0
KUWAIT              0           0     0           0      0         0       0          0         0   0        0
MALAYSIA            0           0     0           0      0         0       0          0         0   0        0
MEXICO              0           0     0           0      0         0       0          0         0   0        0
NEWZEALAND          0           0     0           0      0         0       0          0         0   0        0
PERU                0           0     0           0      0         0       0          0         0   0        0
PHILIPPINE          0           0     0           0      0         0       0          0         0   0        0
QATAR               0           0     0           0      0         0       0          0         0   0        0
RUSSIAN             0           0     0           0      0         0       0          0         0   0        0
ARABIA              0           0     0           0      0         0       0          0         0   0        0
SINGAPORE           0           0     0           0      0         0       0          0         0   0        0
THAILAND            0           0     0           0      0         0       0          0         0   0        0
US                  0           0     0           0      0         0       0          0         0   0        0
VIETNAM             0           0     0           0      0         0       0          0         0   0        0
ROW                 0           0     0           0      0         0       0          0         0   0        0   ;




***************CALIBRATION**************
PARAMETERS

DISTN(R,G,F)      SHARE PARAMETER IN PRODUCTION FUNCTION
SCALE(R,G)        SCALE PAREMETER IN PRODUCTION

SHARE1(R)         SHARE PARAMETER OF COMPOSITE TRADABLE GOODS
SHARE2(R)         SHARE PARAMETER OF NONTRADABLE GOODS
SHARE3(R)         SHARE PARAMETER OF INSIDE MONEY
SHARE4(R,RR)      SHARE PARAMETER OF TRADABLE GOODS
PM1(R)            PRICE FOR COMPOSITE TRADABLE GOODS

ELASC1(R)         FIRST LEVEL CONSUMPTION ELASTICITY OF SUBSITUTION
ELASC2(R)         SECOND LEVEL CONSUMPTION ELASTICITY OF SUBSTITUTION
ELASP(R,G)        PRODUCTION ELASTICITY OF SUBSITUTION
;


ELASC1(R) = ELASC10(R)*2.5;
ELASC2(R) = ELASC20(R)*2.5;
ELASP(R,G) = ELASP0(R,G)*2.5;

DISTN(R,G,F) = ((FACDEM1(R,G,F)**(1/ELASP(R,G))))/SUM(FF,(FACDEM1(R,G,FF)**(1/ELASP(R,G))));
SCALE(R,G) = PRN1(R,G)/(SUM(F,DISTN(R,G,F)*(FACDEM1(R,G,F)**((ELASP(R,G)-1)/ELASP(R,G))))**(ELASP(R,G)/(ELASP(R,G)-1)));

SHARE4(R,RR) = GDEM1(R,RR)*((1+TARIFF(R,RR)+NTARIFF(R,RR))**ELASC2(R))/SUM(RRR,GDEM1(R,RRR)*((1+TARIFF(R,RRR)+NTARIFF(R,RRR))**ELASC2(R)));
PM1(R) = (SUM(RR,SHARE4(R,RR)*((1+TARIFF(R,RR)+NTARIFF(R,RR))**(1-ELASC2(R)))))**(1/(1-ELASC2(R)));
SHARE1(R) = TGDEM1(R)*(PM1(R)**ELASC1(R))/(TGDEM1(R)*(PM1(R)**ELASC1(R))+MONEY1(R)+NGDEM1(R));
SHARE2(R) = NGDEM1(R)/(TGDEM1(R)*(PM1(R)**ELASC1(R))+MONEY1(R)+NGDEM1(R));
SHARE3(R) = MONEY1(R)/(TGDEM1(R)*(PM1(R)**ELASC1(R))+MONEY1(R)+NGDEM1(R));

DISPLAY DISTN,SCALE,PM1,SHARE1,SHARE2,SHARE3,SHARE4,ELASC1,ELASC2,ELASP;


********************MODEL SYSTEM********************
VARIABLES
PRN(R,G)            PRODUCTION OF SECTORS
FACDEM(R,G,F)       FACTOR DEMAND BY GOODS

TGDEM(R)            TRADABLE COMPOSITE GOODS
NGDEM(R)            NONTRADABLE GOODS
MONEY(R)            INSIDE MONEY
GDEM(R,RR)          TRADABLE GOODS DEMAND

P(R,G)              PRICE OF PRODUCTION
PRCT(R,RR)          PRICE OF TRADABLE GOODS
PRCN(R)             PRICE OF NON-TRADABLE GOODS
PRCM(R)             PRICE OF INSIDE MONEY
PM(R)               PRICE OF COMPOSITE TRADABLE GOODS
W(R,F)              WAGES BY FACTORS

SURPLUS(R)          TRADE IMBALANCE DENOTED BY INSIDE MONEY
REV(R)              REVENUE COLLECTION
NREV(R)             COSTS FOR SOLVING NON-TARIFF TRADE COSTS
INC(R)              INCOME BY INDIVIDUAL

Z(R)                EXCESS DEMAND OF TRADABLE GOODS
DMY                 A DUMMY OBJECTIVE VARIABLE

EQUATIONS
PRNDEF(R,G)         DEFINITION OF PRODUCTION FUNCTION
FACDEMDEF(R,G,F)    DEFINITION OF FACTOR DEMAND

TGDEMDEF(R)         DEFINITION OF TRADABLE COMPOSITE GOODS
NGDEMDEF(R)         DEFINITION OF NON-TRADABLE GOODS
MONEYDEF(R)         DEFINITION OF INSIDE MONEY
GDEMDEF(R,RR)       DEFINITION OF TRADABLE GOODS DEMAND

PRCTDEF(R,RR)       DEFINITION OF TRADABLE GOODS CONSUMER PRICE
PRCNDEF(R)          DEFINITION OF NONTRADABLE GOODS CONSUMER PRICE
PMDEF(R)            DEFINITION OF AMINGTON PRICES

SURPLUSDEF(R)       DEFINITION OF TRADE IMBALANCE DENOTED BY INSIDE MONEY
REVDEF(R)           DEFINITION OF REVENUE COLLECTION
NREVDEF(R)          DEFINITION OF COSTS FOR SLOVING NON-TARIFF BARRIERS
INCDEF(R)           INCOME DEFINITION

FACDEF(R,F)         DEFINITION OF FACTOR CLEARANCE
ZPROF(R,G)          ZERO PROFIT CONDITION
SDEF                SURPLUS CLEARANCE DEFINITION
NGDEF(R)            NONTRADABLE GOODS CLEARANCE CONDITION
TGDEF(R)            TRADABLE GOODS CLEARANCE CONDITION

DMYOBJ              DEFINITION OF DUMMY OBJECTIVE FUNCTION
;

PRNDEF(R,G)..
PRN(R,G) =E= SCALE(R,G)*SUM(F,DISTN(R,G,F)*(FACDEM(R,G,F)**
((ELASP(R,G)-1)/ELASP(R,G))))**(ELASP(R,G)/(ELASP(R,G)-1));

FACDEMDEF(R,G,F)..
FACDEM(R,G,F) =E= (1/SCALE(R,G))*PRN(R,G)*(DISTN(R,G,F)+((SUM(FF,DISTN(R,G,FF))
-DISTN(R,G,F))*((DISTN(R,G,F)*(SUM(FF,W(R,FF))-W(R,F)))/((SUM(FF,DISTN(R,G,FF))-DISTN(R,G,F))*W(R,F)))**
(1-ELASP(R,G))))**(ELASP(R,G)/(1-ELASP(R,G)));

TGDEMDEF(R)..
TGDEM(R) =E= (SHARE1(R)*INC(R))/((PM(R)**ELASC1(R))*(SHARE1(R)*(PM(R)**(1-ELASC1(R)))+SHARE2(R)*(PRCN(R)**
(1-ELASC1(R)))+SHARE3(R)*(PRCM(R)**(1-ELASC1(R)))));

NGDEMDEF(R)..
NGDEM(R) =E= (SHARE2(R)*INC(R))/((PRCN(R)**ELASC1(R))*(SHARE1(R)*(PM(R)**(1-ELASC1(R)))+SHARE2(R)*(PRCN(R)**
(1-ELASC1(R)))+SHARE3(R)*(PRCM(R)**(1-ELASC1(R)))));

MONEYDEF(R)..
MONEY(R) =E= (SHARE3(R)*INC(R))/((PRCM(R)**ELASC1(R))*(SHARE1(R)*(PM(R)**(1-ELASC1(R)))+SHARE2(R)*(PRCN(R)**
(1-ELASC1(R)))+SHARE3(R)*(PRCM(R)**(1-ELASC1(R)))));

GDEMDEF(R,RR)..
GDEM(R,RR) =E= (SHARE4(R,RR)*PM(R)*TGDEM(R))/((PRCT(R,RR)**ELASC2(R))*SUM(RRR,SHARE4(R,RRR)*(PRCT(R,RRR)**(1-ELASC2(R)))));

PRCTDEF(R,RR)..
PRCT(R,RR) =E= P(RR,"TRADABLE")*(1+TARIFF(R,RR)+0.05*RTA(R,RR)+NTARIFF(R,RR));

PRCNDEF(R)..
PRCN(R) =E= P(R,"NONTRADABLE");

PMDEF(R)..
PM(R) =E= (SUM(RR,SHARE4(R,RR)*(PRCT(R,RR)**(1-ELASC2(R)))))**(1/(1-ELASC2(R)));

SURPLUSDEF(R)..
SURPLUS(R) =E= MONEY(R)-1000;

REVDEF(R)..
REV(R) =E= SUM(RR,GDEM(R,RR)*P(RR,"TRADABLE")*TARIFF(R,RR));

NREVDEF(R)..
NREV(R) =E= SUM(RR,GDEM(R,RR)*P(RR,"TRADABLE")*(NTARIFF(R,RR)+0.05*RTA(R,RR)));

INCDEF(R)..
INC(R) =E= SUM(FF,ENDW(R,FF)*W(R,FF))+REV(R)+1000;

FACDEF(R,F)..
ENDW(R,F) =E= SUM(G,FACDEM(R,G,F));

ZPROF(R,G)..
PRN(R,G)*P(R,G) =E= SUM(F,FACDEM(R,G,F)*W(R,F));

SDEF..
SUM(R,SURPLUS(R)) =E= 0;

NGDEF(R)..
NGDEM(R) =E= PRN(R,"NONTRADABLE")-(NREV(R)/PRCN(R));

TGDEF(R)..
Z(R) =E= SUM(RR,GDEM(RR,R))-PRN(R,"TRADABLE");

DMYOBJ..
DMY =E= SUM(R,P(R,"TRADABLE")*Z(R)*P(R,"TRADABLE")*Z(R))/10000;

MODEL CHUNDING /ALL/;

PRN.LO(R,G)=0.1;
PRN.LO("AUSTRALIA",G)=100;
PRN.LO("BAHRAIN",G)=2;
PRN.LO("BRAZIL",G)=100;
PRN.LO("BRUNEI",G)=1;
PRN.LO("CANADA",G)=100;
PRN.LO("CHILE",G)=10;
PRN.LO("CHINA",G)=1000;
PRN.LO("EU",G)=1000;
PRN.LO("INDIA",G)=100;
PRN.LO("INDONESIA",G)=50;
PRN.LO("JAPAN",G)=100;
PRN.LO("KOREA",G)=60;
PRN.LO("KUWAIT",G)=1;
PRN.LO("MALAYSIA",G)=10;
PRN.LO("MEXICO",G)=50;
PRN.LO("NEWZEALAND",G)=2;
PRN.LO("PERU",G)=10;
PRN.LO("PHILIPPINE",G)=10;
PRN.LO("QATAR",G)=6;
PRN.LO("RUSSIAN",G)=100;
PRN.LO("ARABIA",G)=10;
PRN.LO("SINGAPORE",G)=100;
PRN.LO("THAILAND",G)=5;
PRN.LO("US",G)=100;
PRN.LO("VIETNAM",G)=10;
PRN.LO("ROW",G)=500;

FACDEM.LO(R,G,F)=0.1;
FACDEM.LO("AUSTRALIA",G,F)=60;
FACDEM.LO("BAHRAIN",G,F)=1;
FACDEM.LO("BRAZIL",G,F)=10;
FACDEM.LO("BRUNEI",G,F)=0.1;
FACDEM.LO("CANADA",G,F)=20;
FACDEM.LO("CHILE",G,F)=5;
FACDEM.LO("CHINA",G,F)=600;
FACDEM.LO("EU",G,F)=600;
FACDEM.LO("INDIA",G,F)=20;
FACDEM.LO("INDONESIA",G,F)=30;
FACDEM.LO("JAPAN",G,F)=60;
FACDEM.LO("KOREA",G,F)=50;
FACDEM.LO("KUWAIT",G,F)=1;
FACDEM.LO("MALAYSIA",G,F)=10;
FACDEM.LO("MEXICO",G,F)=20;
FACDEM.LO("NEWZEALAND",G,F)=2;
FACDEM.LO("PERU",G,F)=5;
FACDEM.LO("PHILIPPINE",G,F)=6;
FACDEM.LO("QATAR",G,F)=3;
FACDEM.LO("RUSSIAN",G,F)=20;
FACDEM.LO("ARABIA",G,F)=20;
FACDEM.LO("SINGAPORE",G,F)=5;
FACDEM.LO("THAILAND",G,F)=2;
FACDEM.LO("US",G,F)=100;
FACDEM.LO("VIETNAM",G,F)=2;
FACDEM.LO("ROW",G,F)=200;

TGDEM.LO(R)=0.1;
TGDEM.LO("AUSTRALIA")=100;
TGDEM.LO("BAHRAIN")=2;
TGDEM.LO("BRAZIL")=60;
TGDEM.LO("BRUNEI")=1;
TGDEM.LO("CANADA")=100;
TGDEM.LO("CHILE")=10;
TGDEM.LO("CHINA")=1000;
TGDEM.LO("EU")=1000;
TGDEM.LO("INDIA")=100;
TGDEM.LO("INDONESIA")=60;
TGDEM.LO("JAPAN")=300;
TGDEM.LO("KOREA")=100;
TGDEM.LO("KUWAIT")=5;
TGDEM.LO("MALAYSIA")=50;
TGDEM.LO("MEXICO")=100;
TGDEM.LO("NEWZEALAND")=10;
TGDEM.LO("PERU")=10;
TGDEM.LO("PHILIPPINE")=20;
TGDEM.LO("QATAR")=5;
TGDEM.LO("RUSSIAN")=100;
TGDEM.LO("ARABIA")=60;
TGDEM.LO("SINGAPORE")=60;
TGDEM.LO("THAILAND")=60;
TGDEM.LO("US")=1000;
TGDEM.LO("VIETNAM")=20;
TGDEM.LO("ROW")=1000;

NGDEM.LO(R)=0.1;
NGDEM.LO("AUSTRALIA")=100;
NGDEM.LO("BAHRAIN")=1;
NGDEM.LO("BRAZIL")=100;
NGDEM.LO("BRUNEI")=1;
NGDEM.LO("CANADA")=500;
NGDEM.LO("CHILE")=10;
NGDEM.LO("CHINA")=1000;
NGDEM.LO("EU")=1000;
NGDEM.LO("INDIA")=500;
NGDEM.LO("INDONESIA")=60;
NGDEM.LO("JAPAN")=600;
NGDEM.LO("KOREA")=100;
NGDEM.LO("KUWAIT")=5;
NGDEM.LO("MALAYSIA")=10;
NGDEM.LO("MEXICO")=100;
NGDEM.LO("NEWZEALAND")=10;
NGDEM.LO("PERU")=10;
NGDEM.LO("PHILIPPINE")=20;
NGDEM.LO("QATAR")=5;
NGDEM.LO("RUSSIAN")=100;
NGDEM.LO("ARABIA")=20;
NGDEM.LO("SINGAPORE")=60;
NGDEM.LO("THAILAND")=10;
NGDEM.LO("US")=1000;
NGDEM.LO("VIETNAM")=10;
NGDEM.LO("ROW")=500;

MONEY.LO(R)=100;
MONEY.LO("AUSTRALIA")=800;
MONEY.LO("BAHRAIN")=800;
MONEY.LO("BRAZIL")=800;
MONEY.LO("BRUNEI")=800;
MONEY.LO("CANADA")=600;
MONEY.LO("CHILE")=600;
MONEY.LO("CHINA")=900;
MONEY.LO("EU")=800;
MONEY.LO("INDIA")=500;
MONEY.LO("INDONESIA")=600;
MONEY.LO("JAPAN")=500;
MONEY.LO("KOREA")=800;
MONEY.LO("KUWAIT")=800;
MONEY.LO("MALAYSIA")=800;
MONEY.LO("MEXICO")=600;
MONEY.LO("NEWZEALAND")=600;
MONEY.LO("PERU")=600;
MONEY.LO("PHILIPPINE")=600;
MONEY.LO("QATAR")=800;
MONEY.LO("RUSSIAN")=900;
MONEY.LO("ARABIA")=900;
MONEY.LO("SINGAPORE")=800;
MONEY.LO("THAILAND")=600;
MONEY.LO("US")=100;
MONEY.LO("VIETNAM")=600;
MONEY.LO("ROW")=800;

REV.LO(R)=0.05;
REV.LO("AUSTRALIA")=2;
REV.LO("BAHRAIN")=0.1;
REV.LO("BRAZIL")=6;
REV.LO("BRUNEI")=0.2;
REV.LO("CANADA")=6;
REV.LO("CHILE")=2;
REV.LO("CHINA")=60;
REV.LO("EU")=20;
REV.LO("INDIA")=10;
REV.LO("INDONESIA")=3;
REV.LO("JAPAN")=10;
REV.LO("KOREA")=10;
REV.LO("KUWAIT")=0.2;
REV.LO("MALAYSIA")=2;
REV.LO("MEXICO")=2;
REV.LO("NEWZEALAND")=0.2;
REV.LO("PERU")=0.3;
REV.LO("PHILIPPINE")=1;
REV.LO("QATAR")=0.2;
REV.LO("RUSSIAN")=2;
REV.LO("ARABIA")=2;
REV.LO("SINGAPORE")=0.1;
REV.LO("THAILAND")=2;
REV.LO("US")=10;
REV.LO("VIETNAM")=2;
REV.LO("ROW")=50;

NREV.LO(R)=0.1;
NREV.LO("AUSTRALIA")=10;
NREV.LO("BAHRAIN")=1;
NREV.LO("BRAZIL")=6;
NREV.LO("BRUNEI")=0.2;
NREV.LO("CANADA")=6;
NREV.LO("CHILE")=2;
NREV.LO("CHINA")=60;
NREV.LO("EU")=20;
NREV.LO("INDIA")=10;
NREV.LO("INDONESIA")=10;
NREV.LO("JAPAN")=50;
NREV.LO("KOREA")=10;
NREV.LO("KUWAIT")=2;
NREV.LO("MALAYSIA")=2;
NREV.LO("MEXICO")=10;
NREV.LO("NEWZEALAND")=2;
NREV.LO("PERU")=3;
NREV.LO("PHILIPPINE")=5;
NREV.LO("QATAR")=1;
NREV.LO("RUSSIAN")=10;
NREV.LO("ARABIA")=6;
NREV.LO("SINGAPORE")=10;
NREV.LO("THAILAND")=2;
NREV.LO("US")=60;
NREV.LO("VIETNAM")=2;
NREV.LO("ROW")=100;

INC.LO(R)=1;
INC.LO("AUSTRALIA")=600;
INC.LO("BAHRAIN")=10;
INC.LO("BRAZIL")=600;
INC.LO("BRUNEI")=2;
INC.LO("CANADA")=600;
INC.LO("CHILE")=60;
INC.LO("CHINA")=1000;
INC.LO("EU")=2000;
INC.LO("INDIA")=500;
INC.LO("INDONESIA")=100;
INC.LO("JAPAN")=500;
INC.LO("KOREA")=100;
INC.LO("KUWAIT")=10;
INC.LO("MALAYSIA")=60;
INC.LO("MEXICO")=100;
INC.LO("NEWZEALAND")=20;
INC.LO("PERU")=50;
INC.LO("PHILIPPINE")=60;
INC.LO("QATAR")=10;
INC.LO("RUSSIAN")=500;
INC.LO("ARABIA")=100;
INC.LO("SINGAPORE")=100;
INC.LO("THAILAND")=100;
INC.LO("US")=1000;
INC.LO("VIETNAM")=10;
INC.LO("ROW")=1000;

*GDEM.LO(R,RR)=0.1;

P.LO(R,G)=0.3;
PRCT.LO(R,RR)=0.4;
PRCN.LO(R)=0.4;
PM.LO(R)=0.4;
W.LO(R,F)=0.3;
PRCM.FX(R)=1;
W.FX("ARABIA","L")=1;

SOLVE CHUNDING USING NLP MINIMIZING DMY;

DISPLAY PRN.L, FACDEM.L, TGDEM.L, NGDEM.L, MONEY.L, GDEM.L, P.L, PRCT.L, PRCN.L, PM.L, W.L, SURPLUS.L, REV.L, INC.L;


***************SPECIFIC CALCULATION******************
PARAMETERS

PRODUCTION0(R)
/AUSTRALIA   1285.155,    BAHRAIN       26.709,    BRAZIL      1724.869
BRUNEI         8.077,    CANADA      2121.899,    CHILE        248.554
CHINA      14910.163,    EU         21065.607,    INDIA       2744.940
INDONESIA    881.202,    JAPAN       5185.012,    KOREA       1658.737
KUWAIT        90.473,    MALAYSIA     336.591,    MEXICO      1619.436
NEWZEALAND   173.029,    PERU         181.919,    PHILIPPINE   253.912
QATAR        121.497,    RUSSIAN     1633.157,    ARABIA       786.500
SINGAPORE    717.530,    THAILAND     477.745,    US         27065.162
VIETNAM      450.403,    ROW         9641.640/,


EXPORT0(R)        TOTAL EXPORT OF ONE COUNTRY IN BASE CASE
/AUSTRALIA   350.797,    BAHRAIN      36.906,    BRAZIL      386.408
BRUNEI       15.847,    CANADA      563.712,    CHILE       130.274
CHINA      3228.478,    EU         3180.615,    INDIA       511.755
INDONESIA   297.498,    JAPAN       958.239,    KOREA       775.116
KUWAIT      181.806,    MALAYSIA    355.397,    MEXICO      528.354
NEWZEALAND   65.230,    PERU         88.524,    PHILIPPINE  141.534
QATAR       201.865,    RUSSIAN     687.584,    ARABIA      394.762
SINGAPORE   592.822,    THAILAND    361.487,    US         1521.399
VIETNAM     312.379,    ROW        4475.747/,

IMPORT0(R)        TOTAL IMPORT OF ONE COUNTRY IN BASE CASE
/AUSTRALIA   204.325,    BAHRAIN      21.218,    BRAZIL      157.505
BRUNEI        4.237,    CANADA      515.771,    CHILE        64.714
CHINA      2720.683,    EU         3089.740,    INDIA       558.314
INDONESIA   158.484,    JAPAN       833.069,    KOREA       561.778
KUWAIT       33.758,    MALAYSIA    212.821,    MEXICO      534.908
NEWZEALAND   41.531,    PERU         39.682,    PHILIPPINE  104.808
QATAR        25.467,    RUSSIAN     227.734,    ARABIA      132.884
SINGAPORE   398.268,    THAILAND    247.116,    US         4453.650
VIETNAM     248.583,    ROW        4753.484/,

BALANCE0(R)       TOTAL IMBALNCE OF ONE COUNTRY IN BASE CASE
/AUSTRALIA    146.472,    BAHRAIN       15.687,    BRAZIL       228.904
BRUNEI        11.609,    CANADA        47.941,    CHILE         65.561
CHINA        507.795,    EU            90.875,    INDIA        -46.559
INDONESIA    139.014,    JAPAN        125.171,    KOREA        213.338
KUWAIT       148.048,    MALAYSIA     142.576,    MEXICO        -6.554
NEWZEALAND    23.698,    PERU          48.842,    PHILIPPINE    36.726
QATAR        176.398,    RUSSIAN      459.850,    ARABIA       261.878
SINGAPORE    194.554,    THAILAND     114.371,    US         -2932.252
VIETNAM       63.796,    ROW         -277.738/,

TRADE0(R)         TOTAL TRADE OF ONE COUNTRY IN BASE CASE
/AUSTRALIA   555.122,    BAHRAIN      58.124,    BRAZIL      543.913
BRUNEI       20.084,    CANADA     1079.483,    CHILE       194.988
CHINA      5949.161,    EU         6270.355,    INDIA      1070.069
INDONESIA   455.983,    JAPAN      1791.308,    KOREA      1336.893
KUWAIT      215.564,    MALAYSIA    568.217,    MEXICO     1063.262
NEWZEALAND  106.761,    PERU        128.206,    PHILIPPINE  246.342
QATAR       227.332,    RUSSIAN     915.318,    ARABIA      527.646
SINGAPORE   991.091,    THAILAND    608.603,    US         5975.049
VIETNAM     560.961,    ROW        9229.231/,

NGDEM0(R)       NON-TRADABLE GOODS DEMAND IN BASE CASE
/AUSTRALIA   1109.424,    BAHRAIN       23.385,    BRAZIL      1507.238
BRUNEI         8.363,    CANADA       686.826,    CHILE        249.275
CHINA       6316.908,    EU         13292.105,    INDIA       1476.661
INDONESIA    532.273,    JAPAN       3161.310,    KOREA        753.002
KUWAIT       118.464,    MALAYSIA      76.615,    MEXICO       331.364
NEWZEALAND   174.683,    PERU         171.116,    PHILIPPINE   242.886
QATAR        170.015,    RUSSIAN     1037.058,    ARABIA       342.374
SINGAPORE    148.883,    THAILAND     218.726,    US         15137.435
VIETNAM       62.894,    ROW         1619.545/,

UTILITY0(R)     TOTAL UTILITY IN BASE CASE
/AUSTRALIA   1641.241,    BAHRAIN      146.004,    BRAZIL      2072.775
BRUNEI        68.737,    CANADA      1836.626,    CHILE        508.883
CHINA      13551.391,    EU         18767.579,    INDIA       3089.987
INDONESIA   1307.929,    JAPAN       5080.714,    KOREA       1841.649
KUWAIT       287.960,    MALAYSIA     522.188,    MEXICO      1356.338
NEWZEALAND   400.854,    PERU         416.620,    PHILIPPINE   601.692
QATAR        370.229,    RUSSIAN     1702.430,    ARABIA       859.401
SINGAPORE    844.760,    THAILAND     737.283,    US         21415.739
VIETNAM      624.876,    ROW         7135.212/,

PRCN0(R)       CONSUMPTION PICE OF NON-TRADABLE GOODS IN BASE CASE
/AUSTRALIA  0.896,    BAHRAIN    0.708,    BRAZIL     0.923,    BRUNEI     0.594
CANADA     1.238,    CHILE      0.834,    CHINA      1.096,    EU         1.124
INDIA      1.010,    INDONESIA  0.846,    JAPAN      1.043,    KOREA      1.024
KUWAIT     0.643,    MALAYSIA   0.939,    MEXICO     1.327,    NEWZEALAND 0.844
PERU       0.819,    PHILIPPINE 0.767,    QATAR      0.635,    RUSSIAN    0.985
ARABIA     1.000,    SINGAPORE  1.080,    THAILAND   0.946,    US         1.314
VIETNAM    1.059,    ROW        0.871/,

EMPLOYMENT0(R)
/AUSTRALIA   190.107,    BAHRAIN       2.077,    BRAZIL      268.201
BRUNEI        0.612,    CANADA      719.878,    CHILE        16.670
CHINA      3852.030,    EU         3912.742,    INDIA       804.216
INDONESIA   288.083,    JAPAN      1228.227,    KOREA       580.286
KUWAIT        3.008,    MALAYSIA    192.625,    MEXICO      603.854
NEWZEALAND    6.332,    PERU         18.825,    PHILIPPINE   16.263
QATAR         3.990,    RUSSIAN     435.712,    ARABIA      310.507
SINGAPORE   326.200,    THAILAND    198.790,    US         2660.231
VIETNAM     229.023,    ROW        5402.983/,

GDEM0(R,RR)     GOODS DEMAND IN THE BASE CASE
PRCT0(R,RR)     CONSUMPTION PRICE OF TRADABLE GOODS IN BASE CASE
;


TABLE GDEM0(R,RR)
             AUSTRALIA     BAHRAIN      BRAZIL      BRUNEI      CANADA

AUSTRALIA      152.549       0.160       0.732       1.934       0.900
BAHRAIN          1.281      12.680       0.847                   0.112
BRAZIL           1.374       0.257     211.265       0.003       1.225
BRUNEI           0.068                   0.001       8.534       0.005
CANADA           2.945       0.092       7.176       0.031     246.109
CHILE            0.321       0.002       7.730       0.003       0.494
CHINA          165.985       0.429     113.193       1.097      19.953
EU              22.569       5.229      59.114       0.730      27.511
INDIA           18.969       1.419       5.783       1.634       2.081
INDONESIA        6.593       0.141       1.895       0.067       0.928
JAPAN           66.049       3.230       9.249       9.189       7.557
KOREA           28.104       1.375       4.925       2.321       3.476
KUWAIT                       1.734       0.338       0.003       0.135
MALAYSIA         6.932       0.254       2.367       1.573       0.467
MEXICO           0.609       0.149      11.221       0.005       8.891
NEWZEALAND       6.507       0.021       0.152       0.004       0.281
PERU             0.152       0.002       2.935                   0.410
PHILIPPINE       1.861       0.052       0.722       0.122       0.426
QATAR            0.846       0.020       0.359                   0.091
RUSSIAN          0.902       0.017       3.085                   0.447
ARABIA           0.884       3.814       2.922       0.004       1.040
SINGAPORE        7.490       0.306       1.983       2.018       0.943
THAILAND         7.564       0.381       2.444       3.066       0.557
US              25.441       4.598      74.741       0.712     361.587
VIETNAM          4.428       0.032       2.362       0.201       0.492
ROW             13.524      28.378     102.332       1.977      15.152

         +       CHILE       CHINA          EU       INDIA   INDONESIA

AUSTRALIA        0.529      41.421      28.227       3.387       3.844
BAHRAIN          0.167       1.540       1.961       0.773       0.136
BRAZIL           4.953      25.672      26.903       3.322       1.881
BRUNEI           0.003       1.441       0.595       0.074       0.121
CANADA           3.044      64.197      49.801       5.345       2.858
CHILE           36.903      13.200       8.223       0.904       0.280
CHINA           51.132    3846.731     220.083      22.107      49.570
EU              19.648     482.305    1988.334      68.682      38.693
INDIA            2.696      60.006      40.387     800.414      21.389
INDONESIA        0.156      31.185       7.162       4.215     480.435
JAPAN           12.844     151.915      61.028       5.902      32.582
KOREA            7.278      87.422      44.360       5.927      14.959
KUWAIT           0.048       4.522       4.679       1.727       0.330
MALAYSIA         0.194      33.998      12.207       6.316      14.159
MEXICO           3.710      93.804      48.505       7.210       3.408
NEWZEALAND       0.138       6.782       4.864       0.490       0.964
PERU             2.144       7.964       3.233       0.876       0.433
PHILIPPINE       0.059      16.536       6.143       1.603       9.504
QATAR            0.020       2.853       8.510       1.779       0.207
RUSSIAN          1.705      42.476      76.179       3.218       2.667
ARABIA           0.242      18.340      26.821       5.750       2.487
SINGAPORE        0.150      41.228      33.943       7.400      20.629
THAILAND         0.691      38.529      12.691       4.602      11.862
US              36.455     849.387     669.566     104.432      53.254
VIETNAM          0.469      49.006      10.198       4.062       5.851
ROW              7.818     780.838    1424.508     236.760      59.785

         +       JAPAN       KOREA      KUWAIT    MALAYSIA      MEXICO

AUSTRALIA        3.445       8.650       0.114       8.784       0.445
BAHRAIN          0.737       0.244       0.347       0.165       0.038
BRAZIL           3.642       4.707       0.596       1.666       2.002
BRUNEI     9.931961E-4       0.101                   0.583       0.002
CANADA          16.183       9.503       0.129       3.731       9.576
CHILE            2.125       1.670                   0.274       0.963
CHINA          195.060     231.421      55.547      48.431       4.248
EU              97.206      73.677      15.205      46.066      19.617
INDIA           11.561      15.811      24.073      10.791       0.696
INDONESIA       13.925       7.366       0.692       8.674       0.122
JAPAN          760.225      33.253      23.994      22.040       1.776
KOREA           50.704     190.425      39.737      10.085       1.159
KUWAIT           1.800       1.260      35.764       0.342       0.098
MALAYSIA        13.964       8.944       1.419      19.528       0.179
MEXICO          23.110      22.233       0.072       3.428     116.981
NEWZEALAND       2.695       1.861       0.027       1.672       0.154
PERU             0.944       0.911       0.003       0.273       0.808
PHILIPPINE       9.441       9.970       3.862       4.620       0.070
QATAR            1.140       0.507       0.901       0.345       0.087
RUSSIAN          8.117       6.747                   1.948       0.473
ARABIA           5.105       4.197       1.301       1.417       0.381
SINGAPORE       20.810      13.952      12.800      42.154       1.208
THAILAND        30.761       8.076       2.711      15.968       0.312
US             248.890     136.003      12.130      50.013     322.218
VIETNAM         16.020      46.512       0.912      10.446       0.409
ROW            141.359     109.160      85.964      84.720      31.221

         +  NEWZEALAND        PERU  PHILIPPINE       QATAR     RUSSIAN

AUSTRALIA        8.338       0.380       0.964       0.998       0.169
BAHRAIN          0.083       0.003       0.058                   0.106
BRAZIL           0.086       2.770       0.488       0.790       3.253
BRUNEI           0.008                   0.030       0.010       0.001
CANADA           1.222       2.504       3.006       0.297       1.638
CHILE            0.200       1.804       0.096                   0.070
CHINA           20.309      30.097      20.257      34.016      73.414
EU               8.105      15.418      23.649      34.609     242.968
INDIA            0.990       4.140       1.222      33.784       7.231
INDONESIA        1.061       0.079       1.598       3.782       1.385
JAPAN            4.448       4.444      20.195      50.882      17.788
KOREA            2.171       4.203       5.084      52.359      18.741
KUWAIT           0.099       0.006       0.131       0.151       0.226
MALAYSIA         1.243       0.182       3.689       2.077       1.184
MEXICO           0.627       1.102       1.658       0.259       2.884
NEWZEALAND      34.758       0.063       0.189       0.169       0.170
PERU             0.202      61.278       0.112       0.059       0.452
PHILIPPINE       0.727       0.164     115.799       1.115       1.243
QATAR            0.045       0.109       0.128      94.094       0.268
RUSSIAN          0.212       0.306       0.826       0.115     140.034
ARABIA           0.753       0.019       0.516                   1.313
SINGAPORE        1.287       0.022       8.568      22.057       6.241
THAILAND         1.063       0.215       5.106      10.663       2.409
US              12.621      25.819      38.768       9.557      42.476
VIETNAM          0.806       0.203       2.362       0.452       1.520
ROW             10.538      14.022      45.747      59.805     270.725

         +      ARABIA   SINGAPORE    THAILAND          US     VIETNAM

AUSTRALIA        0.429       6.561      11.937      10.936       3.098
BAHRAIN          7.019       0.094       0.338       0.611       0.154
BRAZIL           2.154       0.495       1.761      13.399       1.656
BRUNEI           0.002       0.340       0.138       0.196       0.016
CANADA           4.065       1.111       4.366     159.852       3.610
CHILE            0.031       0.079       1.074       6.520       0.630
CHINA           55.135      33.312      61.956      92.105      43.028
EU              47.019      25.260      40.235     200.847      50.887
INDIA           29.126      12.193       8.995      16.472       5.805
INDONESIA        4.226      15.210      10.823       4.319       2.633
JAPAN           37.138       8.823      31.637      45.165      17.933
KOREA           27.169       6.782       6.612      29.957      16.295
KUWAIT           1.941       0.118       0.446       1.450       0.434
MALAYSIA         4.372      20.713      13.629       7.802       3.472
MEXICO           0.126       1.942      10.306     150.041       2.737
NEWZEALAND       0.382       1.200       2.175       2.144       0.546
PERU             0.182       0.056       0.458       4.486       0.304
PHILIPPINE       1.741       4.788       8.399       3.753       2.761
QATAR            0.014       0.161       0.386       2.779       0.205
RUSSIAN          0.298       0.732       2.178       6.376       2.165
ARABIA         116.147       1.101       2.371       9.187       1.422
SINGAPORE       13.184       8.691       9.937      21.600       3.134
THAILAND         7.091       6.150      39.063       7.241       4.421
US              46.651      41.996      71.868    2103.796      78.083
VIETNAM          1.377       4.613      12.928       4.831      60.310
ROW            103.887     354.930      67.081     343.050      49.470

         +         ROW

AUSTRALIA       57.589
BAHRAIN          4.749
BRAZIL          50.017
BRUNEI           0.313
CANADA         107.966
CHILE           16.192
CHINA         1252.349
EU            1539.816
INDIA          266.908
INDONESIA       30.686
JAPAN          192.935
KOREA          122.684
KUWAIT          12.361
MALAYSIA        55.283
MEXICO          82.948
NEWZEALAND       7.724
PERU            11.461
PHILIPPINE      16.853
QATAR            2.177
RUSSIAN         59.175
ARABIA          40.484
SINGAPORE      127.331
THAILAND        73.327
US             933.196
VIETNAM         71.545
ROW           1750.535 ;

TABLE PRCT0(R,RR)

             AUSTRALIA     BAHRAIN      BRAZIL      BRUNEI      CANADA

AUSTRALIA        0.896       1.332       1.911       0.978       2.126
BAHRAIN          1.685       0.708       1.752       0.629       2.415
BRAZIL           1.855       1.345       0.923       0.674       2.008
BRUNEI           1.761       1.114       1.451       0.594       1.947
CANADA           1.539       1.381       1.496       0.619       1.238
CHILE            1.622       0.751       1.343       0.629       1.943
CHINA            1.180       1.219       1.302       0.928       1.700
EU               1.374       1.109       1.333       1.224       1.686
INDIA            1.387       1.036       1.465       0.717       1.906
INDONESIA        1.449       1.469       1.730       0.970       2.166
JAPAN            1.236       1.151       1.501       0.905       1.751
KOREA            1.122       1.019       1.285       0.800       1.643
KUWAIT           1.739       1.082       1.650       0.622       2.435
MALAYSIA         1.120       1.054       1.383       0.750       1.770
MEXICO           1.668       1.615       1.424       0.641       1.582
NEWZEALAND       1.165       0.723       2.038       0.963       2.115
PERU             2.151       0.733       1.550       0.614       1.999
PHILIPPINE       1.592       0.753       1.803       1.153       2.114
QATAR            1.523       0.959       1.584       0.623       2.226
RUSSIAN          1.829       0.777       1.631       0.651       2.257
ARABIA           1.730       0.906       1.502       0.628       2.006
SINGAPORE        1.068       0.978       1.387       0.718       1.769
THAILAND         1.033       0.895       1.275       0.719       1.640
US               1.401       1.181       1.341       1.244       1.283
VIETNAM          1.209       0.776       1.417       0.880       1.791
ROW              1.094       0.771       1.091       0.912       1.534

         +       CHILE       CHINA          EU       INDIA   INDONESIA

AUSTRALIA        1.509       1.443       1.722       1.563       1.367
BAHRAIN          0.883       1.886       1.760       1.477       1.753
BRAZIL           1.213       1.546       1.622       1.602       1.585
BRUNEI           1.310       2.061       2.674       1.587       1.650
CANADA           1.308       1.504       1.529       1.554       1.479
CHILE            0.834       1.512       1.664       1.584       1.790
CHINA            1.150       1.096       1.465       1.424       1.235
EU               1.234       1.429       1.124       1.383       1.403
INDIA            1.308       1.545       1.539       1.010       1.235
INDONESIA        1.765       1.601       1.864       1.475       0.846
JAPAN            1.282       1.374       1.597       1.529       1.207
KOREA            1.094       1.248       1.410       1.315       1.107
KUWAIT           0.873       1.671       1.686       1.332       1.558
MALAYSIA         1.374       1.240       1.429       1.210       1.009
MEXICO           1.259       1.618       1.611       1.567       1.689
NEWZEALAND       1.690       1.659       1.807       1.783       1.515
PERU             1.224       1.748       1.906       1.819       2.051
PHILIPPINE       1.786       1.630       1.881       1.790       1.441
QATAR            1.777       1.612       1.524       1.287       1.479
RUSSIAN          1.763       1.544       1.358       1.677       1.611
ARABIA           1.805       1.492       1.529       1.231       1.362
SINGAPORE        1.516       1.238       1.348       1.141       0.926
THAILAND         1.202       1.253       1.340       1.188       0.989
US               1.176       1.408       1.443       1.416       1.386
VIETNAM          1.310       1.271       1.461       1.262       1.185
ROW              1.069       1.885       1.937       1.802       1.287

         +       JAPAN       KOREA      KUWAIT    MALAYSIA      MEXICO

AUSTRALIA        1.438       1.282       1.248       1.173       2.469
BAHRAIN          1.695       1.473       0.983       1.397       3.025
BRAZIL           1.696       1.426       1.150       1.406       2.047
BRUNEI           1.922       1.705       1.012       1.485       2.085
CANADA           1.475       1.359       1.265       1.341       1.694
CHILE            1.604       1.344       0.682       1.547       2.005
CHINA            1.308       1.161       0.981       1.063       1.959
EU               1.482       1.285       0.966       1.194       1.902
INDIA            1.579       1.334       0.849       1.124       2.059
INDONESIA        1.488       1.341       1.186       1.120       2.651
JAPAN            1.043       1.173       0.914       1.103       2.054
KOREA            1.194       1.024       0.780       1.092       1.799
KUWAIT           1.481       1.241       0.643       1.559       1.389
MALAYSIA         1.226       1.089       1.069       0.939       2.089
MEXICO           1.615       1.389       0.694       1.478       1.327
NEWZEALAND       1.633       1.442       0.656       1.250       2.531
PERU             1.853       1.528       0.665       1.807       2.249
PHILIPPINE       1.524       1.336       1.456       1.244       2.495
QATAR            1.328       1.154       1.051       1.276       2.558
RUSSIAN          1.546       1.337       0.706       1.528       2.567
ARABIA           1.411       1.172       0.995       1.333       2.510
SINGAPORE        1.251       1.038       1.167       1.091       1.967
THAILAND         1.187       1.173       0.997       1.047       1.792
US               1.390       1.241       0.968       1.175       1.421
VIETNAM          1.247       1.136       1.127       1.059       2.160
ROW              1.184       1.144       0.761       1.062       1.653

         +  NEWZEALAND        PERU  PHILIPPINE       QATAR     RUSSIAN

AUSTRALIA        1.098       1.966       1.363       1.078       2.011
BAHRAIN          0.894       0.867       0.813       0.859       1.043
BRAZIL           1.865       1.375       1.499       1.089       1.741
BRUNEI           1.638       1.288       1.734       0.998       1.549
CANADA           1.442       1.322       1.310       1.141       1.795
CHILE            1.713       1.203       1.644       1.353       2.084
CHINA            1.279       1.306       1.142       0.934       1.388
EU               1.358       1.389       1.285       0.861       1.191
INDIA            1.491       1.476       1.360       0.809       1.637
INDONESIA        1.513       1.987       1.308       1.110       1.877
JAPAN            1.322       1.456       1.121       0.808       1.460
KOREA            1.189       1.222       1.001       0.734       1.286
KUWAIT           0.884       0.858       1.736       1.037       1.032
MALAYSIA         1.125       1.577       1.017       0.863       1.604
MEXICO           1.611       1.388       1.443       1.224       1.906
NEWZEALAND       0.844       1.790       1.368       1.096       1.918
PERU             1.845       0.819       1.766       0.656       2.143
PHILIPPINE       1.506       1.885       0.767       1.127       2.061
QATAR            1.458       0.859       1.362       0.635       2.200
RUSSIAN          1.644       1.782       1.605       1.417       0.985
ARABIA           1.406       2.063       1.447       0.897       1.999
SINGAPORE        1.094       1.753       0.932       0.710       1.543
THAILAND         1.080       1.288       0.927       0.715       1.392
US               1.367       1.272       1.238       0.978       1.557
VIETNAM          1.243       1.728       1.139       0.926       1.426
ROW              1.111       1.129       1.318       0.767       1.111

         +      ARABIA   SINGAPORE    THAILAND          US     VIETNAM

AUSTRALIA        1.930       1.287       1.091       2.077       1.429
BAHRAIN          1.279       1.490       1.196       2.215       1.215
BRAZIL           1.627       1.623       1.307       1.930       1.626
BRUNEI           1.572       1.757       1.541       3.207       1.908
CANADA           1.620       1.542       1.253       1.493       1.532
CHILE            2.166       1.964       1.364       1.875       1.665
CHINA            1.362       1.220       1.120       1.707       1.229
EU               1.361       1.295       1.129       1.706       1.377
INDIA            1.219       1.278       1.114       1.863       1.324
INDONESIA        1.611       1.182       1.107       2.178       1.484
JAPAN            1.353       1.294       1.077       1.771       1.267
KOREA            1.144       1.309       1.083       1.610       1.281
KUWAIT           1.547       1.957       1.466       2.000       1.855
MALAYSIA         1.420       1.254       1.055       1.663       1.301
MEXICO           1.892       1.601       1.278       1.556       1.724
NEWZEALAND       1.665       1.398       1.210       2.151       1.559
PERU             2.519       2.311       1.488       2.063       2.235
PHILIPPINE       1.886       1.311       1.143       2.143       1.572
QATAR            1.413       1.208       1.065       2.047       1.545
RUSSIAN          2.029       1.691       1.337       2.099       1.533
ARABIA           1.000       1.418       1.254       1.815       1.505
SINGAPORE        1.314       1.080       1.068       1.590       1.069
THAILAND         1.325       1.219       0.946       1.569       1.306
US               1.366       1.292       1.117       1.329       1.377
VIETNAM          1.421       1.197       1.072       1.727       1.059
ROW              1.152       1.262       1.049       1.472       1.731

         +         ROW

AUSTRALIA        1.064
BAHRAIN          1.035
BRAZIL           1.030
BRUNEI           1.617
CANADA           1.080
CHILE            1.117
CHINA            1.063
EU               0.979
INDIA            1.062
INDONESIA        1.326
JAPAN            0.989
KOREA            1.061
KUWAIT           1.031
MALAYSIA         0.986
MEXICO           1.086
NEWZEALAND       1.147
PERU             1.201
PHILIPPINE       1.496
QATAR            1.053
RUSSIAN          0.983
ARABIA           1.004
SINGAPORE        1.019
THAILAND         1.036
US               0.937
VIETNAM          1.424
ROW              0.871 ;

PARAMETER
PRODUCTION(R)     TOTAL PRODUCTION OF TRADABLE GOODS
EXPORT(R)         TOTAL EXPORT OF ONE COUNTRY
IMPORT(R)         TOTAL IMPORT OF ONE COUNTRY
TRADE(R)          TOTAL TRADE OF ONE COUNTRY
UTILITY(R)        TOTAL UTILITY OF ONE COUNTRY
EMPLOYMENT(R)     EXPLOYMENT IN TRADABLE SECTORS
BALANCE(R)        TRADE IMBALANCE
EV(R)             EQUIVALEND VARIATION
CV(R)             COMPENSATION VARIATION

CPRODUCTION       PERCENT CHANGE OF TOTAL PRODUCTION
CEXPORT(R)        PERCENT CHANGE OF TOTAL EXPORT FOR ONE COUNTRY
CIMPORT(R)        PERCENT CHANGE OF TOTAL IMPORT OF ONE COUNTRY
CTRADE(R)         PERCENT CHANGE OF TOTAL TRADE OF ONE COUNTRY
CBALANCE(R)       PERCENT CHANGE OF TRADE IMBALANCE
CUTILITY(R)       PERCENT CHANGE OF UTILITY OF ONE COUNTRY
CEMPLOYMENT(R)    PERCENT CHANGE OF EMPLOYMENT IN TRADABLE SECTOR
EVGDP(R)          EV AS SHARE OF GDP
CVGDP(R)          CV AS SHARE OF GDP

WUTILITY          PERCENT CHANGE OF WORLD UTILITY
WPRODUCTION       PERCENT CHANGE OF WORLD PRODUCTION
WMANUFACTURE      PERCENT CHANGE OF MANUFACTURE SECTOR
WNONMANUFACTURE   PERCENT CHANGE OF NONMANUFACTURE SECTOR
WEMPLOYMENT       PERCENT CHANGE OF WORLD EMPLOYMENT
WTRADE            PERCENT CHANGE OF WORLD TRADE
WEXPORT           PERCENT CHANGE OF WORLD EXPORT
WIMPORT           PERCENT CHANGE OF WORLD IMPORT
;


PRODUCTION(R) = SUM(GG,PRN.L(R,GG)*P.L(R,GG));
EXPORT(R) =  SUM(RR,GDEM.L(RR,R)*P.L(R,"TRADABLE"))-GDEM.L(R,R)*P.L(R,"TRADABLE");
IMPORT(R) =  SUM(RR,GDEM.L(R,RR)*P.L(RR,"TRADABLE"))-GDEM.L(R,R)*P.L(R,"TRADABLE");
TRADE(R) = EXPORT(R)+IMPORT(R);
BALANCE(R) = EXPORT(R)-IMPORT(R);
UTILITY(R) = INC.L(R)*(SHARE1(R)*(PM.L(R)**(1-ELASC1(R)))+SHARE2(R)*(PRCN.L(R)**
(1-ELASC1(R)))) **(1/(ELASC1(R)-1));
EMPLOYMENT(R) = FACDEM.L(R,"TRADABLE","L");
EV(R) = (SUM(RR,GDEM.L(R,RR)*PRCT0(R,RR))+PRCN0(R)*NGDEM.L(R))- (SUM(RR,GDEM0(R,RR)*PRCT0(R,RR))+PRCN0(R)*NGDEM0(R));;
CV(R )= (SUM(RR,GDEM.L(R,RR)*PRCT.L(R,RR))+PRCN.L(R)*NGDEM.L(R))- (SUM(RR,GDEM0(R,RR)*PRCT.L(R,RR))+PRCN.L(R)*NGDEM0(R));

CEXPORT(R) = (EXPORT(R)-EXPORT0(R))*100/EXPORT0(R);
CIMPORT(R) = (IMPORT(R)-IMPORT0(R))*100/IMPORT0(R);
CTRADE(R) = (TRADE(R)-TRADE0(R))*100/TRADE0(R);
CBALANCE(R) = (BALANCE(R)-BALANCE0(R))*100/BALANCE0(R);
CPRODUCTION(R) = (PRODUCTION(R)-PRODUCTION0(R))*100/PRODUCTION0(R);
CUTILITY(R) = (UTILITY(R)-UTILITY0(R))*100/UTILITY0(R);
CEMPLOYMENT(R) = (EMPLOYMENT(R)-EMPLOYMENT0(R))*100/EMPLOYMENT0(R);
EVGDP(R) = EV(R)*100/PRODUCTION(R);
CVGDP(R) = CV(R)*100/PRODUCTION(R);

WUTILITY = (SUM(R,UTILITY(R))-SUM(R,UTILITY0(R)))*100/SUM(R,UTILITY0(R));
WPRODUCTION = (SUM(R,PRODUCTION(R))-SUM(R,PRODUCTION0(R)))*100/SUM(R,PRODUCTION0(R));
WEMPLOYMENT = (SUM(R,EMPLOYMENT(R))-SUM(R,EMPLOYMENT0(R)))*100/SUM(R,EMPLOYMENT0(R));
WTRADE = (SUM(R,TRADE(R))-SUM(R,TRADE0(R)))*100/SUM(R,TRADE0(R));
WEXPORT = (SUM(R,EXPORT(R))-SUM(R,EXPORT0(R)))*100/SUM(R,EXPORT0(R));
WIMPORT = (SUM(R,IMPORT(R))-SUM(R,IMPORT0(R)))*100/SUM(R,IMPORT0(R));


DISPLAY CUTILITY,CPRODUCTION,CEMPLOYMENT,CEXPORT,CIMPORT,CTRADE,CBALANCE,CVGDP,EVGDP
WUTILITY,WPRODUCTION,WEMPLOYMENT,WTRADE,WEXPORT,WIMPORT;
